% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_clear_summary}
\alias{fg_clear_summary}
\title{Removes all summary statistics.}
\usage{
fg_clear_summary(fg)
}
\arguments{
\item{fg}{flowGraph object.}
}
\value{
flowGraph object with an empty \code{summary} slot.
}
\description{
Removes all summary statistics in a flowGraph object;
 we recommend doing this to save space.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores, node_features="count")
 fg_get_summary_desc(fg)

 fg <- fg_clear_summary(fg)
 fg_get_summary_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_summary}}
}
