% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{unitytransform-class}
\alias{unitytransform-class}
\alias{unitytransform}
\alias{show,unitytransform-method}
\alias{eval,unitytransform,missing-method}
\title{Class "unitytransform"}
\description{
Unity transform class transforms parameters names provided as characters
into unity transform objects which can be evaluated to retrieve the
corresponding columns from the data frame
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"function"}.}

\item{\code{parameters}}{Object of class \code{"character"} -- the flow
parameters to be transformed.}

\item{\code{transformationId}}{Object of class \code{"character"} -- a unique Id to
reference the transformation.}
}}

\section{Objects from the Class}{
 Objects can be created by calls to the
constructor \code{unitytransform(parameters,transformationId)}.
}

\section{Extends}{

Class \code{"\linkS4class{transform}"}, directly.

Class \code{"\linkS4class{transformation}"}, by class "transform", distance 2.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "transform", distance 3.
}

\examples{

  dat <- read.FCS(system.file("extdata","0877408774.B08",
  package="flowCore"))
  un1<-unitytransform(c("FSC-H","SSC-H"),transformationId="un1")
  transOut<-eval(un1)(exprs(dat))

}
\seealso{
dg1polynomial, ratio

Other mathematical transform classes: 
\code{\link{EHtrans-class}},
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{invsplitscale-class}},
\code{\link{lintGml2-class}},
\code{\link{logarithm-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratio-class}},
\code{\link{ratiotGml2-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}}
}
\author{
Gopalakrishnan N, F.Hahne
}
\concept{mathematical transform classes}
\keyword{classes}
