% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{lnTransform}
\alias{lnTransform}
\title{Create the definition of a ln transformation function (natural logarthim) to
be applied on a data set}
\usage{
lnTransform(transformationId="defaultLnTransform", r=1, d=1)
}
\arguments{
\item{transformationId}{character string to identify the transformation}

\item{r}{positive double that corresponds to a scale factor.}

\item{d}{positive double that corresponds to a scale factor}
}
\value{
Returns an object of class \code{transform}.
}
\description{
Create the definition of the ln Transformation that will be applied on some
parameter via the \code{transform} method.  The definition of this function
is currently x<-log(x)*(r/d).  The transformation would normally be used to
convert to a linear valued parameter to the natural logarithm scale.
Typically r and d are both equal to 1.0. Both must be positive.
}
\examples{

  data(GvHD)
  lnTrans <- lnTransform(transformationId="ln-transformation", r=1, d=1)
  ln1 <- transform(GvHD, transformList('FSC-H', lnTrans))

opar = par(mfcol=c(2, 1))
plot(density(exprs(GvHD[[1]])[ ,1]), main="Original")
plot(density(exprs(ln1[[1]])[ ,1]), main="Ln Transform")


}
\seealso{
\code{\link{transform-class}}, \code{\link{transform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{inverseLogicleTransform}()},
\code{\link{linearTransform}()},
\code{\link{logTransform}()},
\code{\link{logicleTransform}()},
\code{\link{quadraticTransform}()},
\code{\link{scaleTransform}()},
\code{\link{splitScaleTransform}()},
\code{\link{truncateTransform}()}
}
\author{
B. Ellis and N. LeMeur
}
\concept{Transform functions}
\keyword{methods}
