% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{filterSummaryList-class}
\alias{filterSummaryList-class}
\alias{filterSummaryList}
\alias{toTable,filterSummaryList-method}
\title{Class "filterSummaryList"}
\arguments{
\item{object}{An object of class.
\code{\link[flowCore:filterResultList-class]{filterResultList}} which is to
be summarized.}

\item{\dots}{Further arguments that are passed to the generic.}
}
\value{
An object of class \code{filterSummaryList}.
}
\description{
Class and methods to handle summary statistics for from filtering operations
on whole \code{\link[flowCore:flowSet-class]{flowSets}}.
}
\details{
Calling \code{summary} on a \code{\link{filterResultList}} object prints summary
information on the screen, but also creates objects of class
\code{filterSummaryList} for computational access.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"list"}. The class
directly extends \code{list}, and this slot holds the list data.}
}}

\section{Usage}{

summary(object, \dots)
}

\section{Objects from the Class}{


Objects are created by calling \code{summary} on a
\code{link{filterResultList}} object. The user doesn't have to deal with
manual object instantiation.
}

\section{Extends}{

Class \code{"\linkS4class{list}"}, from \code{.Data} part.
}

\section{Methods}{

\describe{
  
  \item{toTable}{\code{signature(x = "filterSummaryList")}: Coerce
    object to \code{data.frame}. Additional factors are added to
    indicate list items in the original object. }
  
}
}

\examples{

library(flowStats)

## Loading example data, creating and applying a curv1Filter
data(GvHD)
dat <- GvHD[1:3]
c1f <- curv1Filter(filterId="myCurv1Filter", x=list("FSC-H"), bwFac=2)
fres <- filter(dat, c1f)

## creating and showing the summary
summary(fres)
s <- summary(fres)

## subsetting
s[[1]]

##accessing details
toTable(s)


}
\seealso{
\code{\linkS4class{filterResult}}, \code{\linkS4class{filterResultList}},
\code{\linkS4class{logicalFilterResult}},
\code{\linkS4class{multipleFilterResult}}, \code{\linkS4class{flowFrame}}
\code{\linkS4class{filterSummary}}
}
\author{
Florian Hahne
}
\keyword{classes}
