% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterAlignment.R
\name{plotClustAlignment,clusterAlignment-method}
\alias{plotClustAlignment,clusterAlignment-method}
\title{plotClustAlignment}
\usage{
\S4method{plotClustAlignment}{clusterAlignment}(object, alignment = 1, ...)
}
\arguments{
\item{object}{\code{clusterAlignment} object.}

\item{alignment}{the set of alignments to plot}

\item{...}{further arguments passed to \code{image}. See
also \code{plotAlignment}}
}
\value{
plot the pairwise alignment
}
\description{
Plotting functions for GCMS data objects
}
\details{
For \code{clusterAlignment} objects, the similarity matrix is plotted and
optionally, the set of matching peaks.  \code{clusterAlignment} objects are
just a collection of all pairwise \code{peakAlignment} objects.
}
\examples{

require(gcspikelite)

# paths and files
gcmsPath <- paste(find.package("gcspikelite"), "data", sep="/")
cdfFiles <- dir(gcmsPath, "CDF", full=TRUE)
eluFiles <- dir(gcmsPath, "ELU", full=TRUE)

# read data, peak detection results
pd <- peaksDataset(cdfFiles[1:2], mz=seq(50,550), rtrange=c(7.5,8.5))
pd <- addAMDISPeaks(pd, eluFiles[1:2])

ca <- clusterAlignment(pd, gap=0.5, D=0.05, df=30, metric=1, type=1)
plotClustAlignment(ca, run = 1)
plotClustAlignment(ca, run = 2)
plotClustAlignment(ca, run = 3)

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{plotAlignment}}
}
\author{
Mark Robinson
}
\keyword{classes}
