% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geseca-plot.R
\name{plotCoregulationProfileReduction}
\alias{plotCoregulationProfileReduction}
\title{Plot a spatial expression profile of a gene set}
\usage{
plotCoregulationProfileReduction(
  pathway,
  object,
  title = NULL,
  assay = DefaultAssay(object),
  reduction = NULL,
  colors = rdbuColors,
  guide = "colourbar",
  minLimit = -3,
  maxLimit = 3,
  ...
)
}
\arguments{
\item{pathway}{Gene set to plot or a list of gene sets (see details below)}

\item{object}{Seurat object}

\item{title}{plot title}

\item{assay}{assay to use for obtaining scaled data, preferably with}

\item{reduction}{reduction to use for plotting (one of the `Seurat::Reductions(object)`)}

\item{colors}{vector of colors to use in the color scheme (default is similar to "RdBu" Brewer's color palette)}

\item{guide}{option for `ggplot2::scale_color_gradientn` to control for presence of the color legend
the same universe of genes in the scaled data}

\item{minLimit}{Numeric value specifying the minimum limit for the color scale.
This defines the lower bound of the z-score used in coloring the feature plot.
Values below this limit are squished to the minimum color.}

\item{maxLimit}{Numeric value specifying the maximum limit for the color scale.
This defines the upper bound of the z-score used in coloring the feature plot.
Values above this limit are squished to the maximum color.}

\item{...}{additional arguments for Seurat::FeaturePlot}
}
\value{
ggplot object (or a list of objects) with the coregulation profile plot

When the input is a list of pathways, pathway names are used for titles.
A list of ggplot objects a returned in that case.
}
\description{
Plot a spatial expression profile of a gene set
}
