% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geseca-multilevel.R
\name{collapsePathwaysGeseca}
\alias{collapsePathwaysGeseca}
\title{Collapse list of enriched pathways to independent ones (GESECA version, highly experimental).}
\usage{
collapsePathwaysGeseca(
  gesecaRes,
  pathways,
  E,
  center = TRUE,
  scale = FALSE,
  eps = min(c(1e-50, gesecaRes$pval)),
  checkDepth = 10,
  nproc = 0,
  BPPARAM = NULL
)
}
\arguments{
\item{gesecaRes}{Table with results of running geseca(), should be filtered
by p-value, for example by selecting ones with padj < 0.01.}

\item{pathways}{List of pathways, should contain all the pathways present in
`gesecaRes`.}

\item{E}{expression matrix, the same as in `geseca()`.}

\item{center}{a logical value indicating whether the gene expression should be centered to have zero mean before the analysis takes place.
The default is TRUE. The value is passed to \link[base]{scale}.}

\item{scale}{a logical value indicating whether the gene expression should be scaled to have
unit variance before the analysis takes place.
The default is FALSE. The value is passed to \link[base]{scale}.}

\item{eps}{eps prameter for internal gesecaMultilevel runs. Default: min(c(1e-50, gesecaRes$pval))}

\item{checkDepth}{how much pathways to check against}

\item{nproc}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}

\item{BPPARAM}{Parallelization parameter used in bplapply.}
}
\description{
Collapse list of enriched pathways to independent ones (GESECA version, highly experimental).
}
