% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathways.R
\name{readPathways}
\alias{readPathways}
\title{Returns a list of pathways from various file formats.}
\usage{
readPathways(
    pathwayFile,
    header = FALSE,
    pathCol = NULL,
    geneCol = NULL,
    minGene = 1L,
    maxGene = Inf
)
}
\arguments{
\item{pathwayFile}{(char) path to file with pathway annotations}

\item{header}{(logical) whether \code{pathwayFile} has a header
(default FALSE)}

\item{pathCol}{(char or int) column name or number with pathway identifiers
(for use with non-GMT input files (eg "Pathway.ID" or 2; default NULL))}

\item{geneCol}{(char or int) column name or number with gene identifiers
(for use with non-GMT input files (eg "Gene.ID" or 5; default NULL))}

\item{minGene}{(integer) minimum number of genes to be considered
in a pathway (default 1)}

\item{maxGene}{(integer) maximum number of genes to be considered
in a pathway (default Inf)}
}
\value{
A list of vectors with pathway annotations.
}
\description{
This function supports custom pathway annotations to use
for fedup pathway enrichment analysis. Current file formats supported are
gmt, txt, and xlsx.
}
\examples{
# Generate pathway list from GMT annotation file
pathways <- readPathways(
    system.file("extdata", "Human_Reactome_November_17_2020_symbol.gmt",
        package = "fedup"
    ),
    minGene = 10, maxGene = 500
)
# Generate pathway list from XLSX annotation file
pathways <- readPathways(
    system.file("extdata", "SAFE_terms.xlsx", package = "fedup"),
    header = TRUE, pathCol = "Enriched.GO.names", geneCol = "Gene.ID"
)
}
