% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasta2dist.R
\name{fasta2dist}
\alias{fasta2dist}
\title{Calculate distances between sequences of a FASTA file}
\usage{
fasta2dist(
  ...,
  outputFile = NULL,
  threads = 2,
  kmer = 6,
  normalize = FALSE,
  compress = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{...}{Input fasta files locations (uncompressed or gzip compressed).}

\item{outputFile}{Output distances file location.}

\item{threads}{Number of java threads to use.}

\item{kmer}{Kmer length to use for analyzing fasta sequences.}

\item{normalize}{Normalize on sequences length.}

\item{compress}{Compress output (adds .gz extension).}

\item{verbose}{Logical. If TRUE, enables verbose output from the Java backend.}
}
\value{
A \code{\link[stats]{dist}} distances object of the calculation.
}
\description{
This function calculates a d2_S type dissimilarity measurement between the
\code{n} sequences (which can represent samples) of a FASTA file.
See \doi{10.1186/s12859-016-1186-3} for more details.
}
\examples{
my.dist <- fasta2dist(
    inputfile = system.file("extdata", "samples.fasta.gz",
        package = "fastreeR"
    )
)
}
\references{
Java implementation:
\url{https://github.com/gkanogiannis/BioInfoJava-Utils}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
