% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotAssayRle.R
\name{plotAssayRle}
\alias{plotAssayRle}
\alias{plotAssayRle,SummarizedExperiment-method}
\title{Plot RLE for a given assay within a SummarizedExperiment}
\usage{
plotAssayRle(x, ...)

\S4method{plotAssayRle}{SummarizedExperiment}(
  x,
  assay = "counts",
  colour = NULL,
  fill = NULL,
  rle_group = NULL,
  by_x = "colnames",
  n_max = Inf,
  trans = NULL,
  ...
)
}
\arguments{
\item{x}{A SummarizedExperiment object}

\item{...}{Passed to \link[ggplot2]{geom_boxplot}}

\item{assay}{The assay to plot}

\item{colour}{Column from \code{colData(x)} to outline the boxplots}

\item{fill}{Column from \code{colData(x)} to fill the boxplots}

\item{rle_group}{Column from \code{colData(x)} to calculate RLE within groups
Commonly an alternative sample label.}

\item{by_x}{Boxplots will be drawn by this grouping variable from
\code{colData(x)}. If not specified, the default values will be \code{colnames(x)}}

\item{n_max}{Maximum number of points to plot}

\item{trans}{character(1). Numerical transformation to apply to the data
prior to RLE calculation}
}
\value{
A ggplot2 object
}
\description{
Plot RLE for a given assay within a SummarizedExperiment
}
\details{
Uses ggplot2 to create an RLE plot for the selected assay. Any numerical
transformation prior to performing the RLE can be specified using the
\code{trans} argument
}
\examples{
data("se")
se$treatment <- c("E2", "E2", "E2", "E2DHT", "E2DHT", "E2DHT")
se$sample <- colnames(se)
## A conventional RLE Plot using all samples
plotAssayRle(se, trans = "log1p", fill = "treatment")
## Calculate RLE within groups
plotAssayRle(se, trans = "log1p", fill = "treatment", rle_group = "treatment")
# Or show groups combined
plotAssayRle(se, trans = "log1p", fill = "treatment", by_x = "treatment")

}
