% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSpecies.R
\name{tableSpecies}
\alias{tableSpecies}
\title{Construct a Genus-Species Data Frame}
\usage{
tableSpecies(tax.file, microbe)
}
\arguments{
\item{tax.file}{a taxonomy file with SSU rRNA sequence names and assigned taxonomic paths, see "*.taxonomy" file outputted by \code{\link{assignTax}}.}

\item{microbe}{a character vector specifying the genera used to construct the Genus-Species data frame}
}
\value{
a Genus-Species data frame, only with the genera specified by \code{microbe} and the included corresponding species .
}
\description{
This function is used to extract only Genus-Species data from the assigned taxonomic paths outputted by \code{\link{assignTax}} and construct a table containing the classified genera and species included in these genera correspondingly.
}
\details{
The outputted Genus-Species table can be used as input for the more accurate genus annotation, which annotates genera as \code{harmful} or \code{harmless} based on their ability to contribute to mammals' host diseases by \code{\link{microAnnotate}}.
}
\examples{
#a table with "Lactobacillus" and "Bacteroids" genera and the included species
genera = c("Lactobacillus","Bacteroides")
#not excute
#tableSpecies(tax.file = "test.taxExtract.wang.taxonomy", microbe = genera)
}

