% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esetPlot-class.R
\docType{class}
\name{esetPlot-class}
\alias{esetPlot-class}
\alias{esetPlot}
\alias{initialize,esetPlot-method}
\title{An S4 class to represent \code{esetPlot} object
expressionSet with visualization data from
dimension-reduction methods}
\usage{
\S4method{initialize}{esetPlot}(.Object, ...)
}
\arguments{
\item{.Object}{\link{esetPlot} object}

\item{...}{additional class arguments}
}
\value{
S4 object of class \code{esetPlot}
}
\description{
Constructor of the \link{esetPlot} class
}
\section{Slots}{

\describe{
\item{\code{dataPlotSamples}}{data.frame with columns 'X', 'Y' with coordinates 
for the samples and with rownames which 
should correspond and be in the same order as the sampleNames of
\code{esetUsed}}

\item{\code{dataPlotGenes}}{data.frame with two columns 'X' and 'Y' with 
coordinates for the genes}

\item{\code{eset}}{expressionSet (or SummarizedExperiment) object with data}

\item{\code{colorVar}}{name of variable (in varLabels of the \code{eset}) used 
for coloring, empty by default}

\item{\code{color}}{character or factor with specified color(s) for the points, 
replicated if needed. This is used only if \code{colorVar} is empty.
By default: 'black' if \code{colorVar} is not specified and default 
\code{ggplot} palette otherwise}

\item{\code{shapeVar}}{name of variable (in varLabels of the \code{eset}) 
used for the shape, empty by default}

\item{\code{shape}}{character or factor with specified shape(s) (pch) for the points, 
replicated if needed. This is used only if \code{shapeVar} is empty.
By default: '15' (filled square) if \code{shapeVar} is not specified 
and default \code{ggplot} shape(s) otherwise}

\item{\code{sizeVar}}{name of variable (in varLabels of the \code{eset}) 
used for the size, empty by default}

\item{\code{size}}{size character or factor with specified size(s) (cex) for the points, 
replicated if needed.
This is used only if \code{sizeVar} is empty.
By default: '2.5' if \code{sizeVar} is not specified and default 
\code{ggplot} size(s) otherwise}

\item{\code{sizeRange,}}{size (cex) range used in the plot, possible only 
if the \code{sizeVar} is 'numeric' or 'integer'}

\item{\code{alphaVar}}{name of variable (in varLabels of the \code{eset}) 
used for the transparency, empty by default.}

\item{\code{alpha}}{alpha character or factor with specified transparency(s) for the points,
replicated if needed. This is used only if \code{shapeVar} is empty. 
By default: '1' if \code{alphaVar} is not specified and default 
\code{ggplot} alpha otherwise.}

\item{\code{alphaRange}}{transparency (alpha) range used in the plot, 
possible only if the \code{alphaVar} is 'numeric' or 'integer'}

\item{\code{symmetryAxes}}{set symmetry for axes, either:
\itemize{
 \item{'combine' (by default): }{both axes are symmetric and with the same limits}
 \item{'separate': }{each axis is symmetric and has its own limits}
 \item{'none': }{axes by default (plot limits)}
}}

\item{\code{cloudGenes}}{logical, if TRUE (by default), include the 
cloud of genes in the spectral map}

\item{\code{cloudGenesColor}}{if \code{cloudGenes} is TRUE, 
color for the cloud of genes, black by default}

\item{\code{cloudGenesNBins}}{number of bins to used for the clouds of genes,
by default the square root of the number of genes}

\item{\code{cloudGenesIncludeLegend}}{logical, if TRUE (FALSE by default) 
include the legend for the cloud of genes (in the top position if multiple legends)}

\item{\code{cloudGenesTitleLegend}}{string with title for the legend for the cloud of genes
'nGenes' by default}

\item{\code{packageTextLabel}}{package used to label the outlying genes/samples/gene sets,
either \code{ggrepel} (by default, only used if package \code{ggrepel} is available),
or \code{ggplot2}}

\item{\code{topGenes}}{numeric indicating which percentile (if <1) or number (if >=1) of genes
most distant to the origin of the plot to annotate, by default: 10 genes are selected
If no genes should be annotated, set this parameter to 0
Currently only available for static plot.}

\item{\code{topGenesCex}}{cex for gene annotation (used when \code{topGenes} > 0)}

\item{\code{topGenesVar}}{variable of the featureData used to label the genes, 
by default: empty, the featureNames are used for labelling (used when \code{topGenes} > 0)}

\item{\code{topGenesJust}}{text justification for the genes 
(used when \code{topGenes} > 0 and if \code{packageTextLabel} is \code{ggplot2}),
by default: c(0.5, 0.5) so centered}

\item{\code{topGenesColor}}{text color for the genes 
(used when \code{topGenes} > 0), black by default}

\item{\code{topSamples}}{numeric indicating which percentile (if <1) or number (if >=1) 
of samples most distant to the origin of the plot to annotate, 
by default: 10 samples are selected
If no samples should be annotated, set this parameter to 0.
Currently available for static plot.}

\item{\code{topSamplesCex}}{cex for sample annotation (used when \code{topSamples} > 0)}

\item{\code{topSamplesVar}}{variable of the phenoData used to label the samples, 
by default: empty, the sampleNames are used for labelling 
(used when \code{topSample}s > 0)}

\item{\code{topSamplesJust}}{text justification for the samples 
(used when \code{topSamples} > 0 and if \code{packageTextLabel} is \code{ggplot2}),
by default: c(0.5, 0.5) so centered}

\item{\code{topSamplesColor}}{text color for the samples 
(used when \code{topSamples} > 0), black by default}

\item{\code{geneSets}}{list of gene sets/pathways, each containing 
identifiers of genes contained in the set.
E.g. pathways from Gene Ontology databases output from the 
\code{\link{getGeneSetsForPlot}} function or any custom list of pathways.
The genes identifiers should correspond to the variable 
\code{geneSetsVar} contained in the phenoData, if not specified
the featureNames are used.
If several gene sets have the same name, they will be 
combine to extract the top gene sets.}

\item{\code{geneSetsVar}}{variable of the featureData used to 
match the genes contained in geneSets,
most probably ENTREZID, if not specified the featureNames
 of the eSet are used
Only used when \code{topGeneSets} > 0 and the parameter 
geneSets is specified.}

\item{\code{geneSetsMaxNChar}}{maximum number of characters for pathway names, 
by default keep entire names
Only used when \code{topGeneSets} > 0 and the parameter \code{geneSets} is specified.}

\item{\code{topGeneSets}}{numeric indicating which percentile (if <=1) or number (if >1) of gene sets
most distant to the origin of the plot to annotate, by default: 10 gene sets are selected
If no gene sets should be annotated, set this parameter to 0.
Currently available for static plot.
Only used when \code{topGeneSets} > 0 and the parameter geneSets is specified.}

\item{\code{topGeneSetsCex}}{cex for gene sets annotation
Only used when \code{topGeneSets} > 0 and the parameter geneSets is specified.}

\item{\code{topGeneSetsJust}}{text justification for the gene sets 
by default: c(0.5, 0.5) so centered
Only used when \code{topGeneSets} > 0, the parameter \code{geneSets} 
is specified and if \code{packageTextLabel} is \code{ggplot2}.}

\item{\code{topGeneSetsColor}}{color for the gene sets 
(used when \code{topGeneSets} > 0 and \code{geneSets} is specified), black by default
Only used when \code{topGeneSets} > 0 and the parameter geneSets is specified.}

\item{\code{includeLegend}}{logical if TRUE (by default) include a legend, 
otherwise not}

\item{\code{includeLineOrigin}}{if TRUE (by default) include vertical line at 
x = 0 and horizontal line at y = 0}
}}

\keyword{internal}
