% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityEnrichment.R
\name{densityEnrichment}
\alias{densityEnrichment}
\title{Visualize Mean Density Ranking of Genes Across Gene Sets}
\usage{
densityEnrichment(
  input.data,
  gene.set.use,
  gene.sets,
  group.by = NULL,
  rug.height = 0.02,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{A \link[SeuratObject]{Seurat} object or a
\link[SingleCellExperiment]{SingleCellExperiment}.}

\item{gene.set.use}{Character. Name of the gene set to display.}

\item{gene.sets}{A named list of character vectors, the result of
\code{\link{getGeneSets}}, or the built-in data object
\code{\link{escape.gene.sets}}.}

\item{group.by}{Character. Metadata column used for grouping. Defaults to
the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{rug.height}{Numeric. Vertical spacing of the hit rug as a fraction of
the y-axis. Default is \code{0.02}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A `patchwork`/`ggplot2` object.
}
\description{
This function allows the user to examine the mean ranking within groups
across the gene set. The visualization uses the density function to display
the relative position and distribution of rank.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc_small <- SeuratObject::pbmc_small
                        
densityEnrichment(pbmc_small, 
                  gene.set.use = "Tcells",
                  gene.sets = gs)

}
