% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startEpiviz.R
\name{startEpiviz}
\alias{startEpiviz}
\title{Start epiviz app and create \code{\link{EpivizApp}} object to manage connection.}
\usage{
startEpiviz(
  host = NULL,
  http_port = NULL,
  path = NULL,
  use_devel = FALSE,
  chr = "chr11",
  start = 99800000,
  end = 103383180,
  debug = FALSE,
  workspace = NULL,
  scripts = NULL,
  gists = NULL,
  use_cookie = TRUE,
  register_function = .register_all_the_epiviz_things,
  open_browser = TRUE,
  server = NULL,
  browser_fun = utils::browseURL,
  ws_host = "localhost",
  ...
)
}
\arguments{
\item{host}{(character) use a host for the epiviz app other than the cbcb.umd.edu hosts.}

\item{http_port}{(integer) port at host serving the epiviz app.}

\item{path}{(character) path at host where epiviz app is located.}

\item{use_devel}{(logical) use the devel epiviz application server (http://epiviz-dev.cbcb.umd.edu).}

\item{chr}{(character) chromosome to browse to on app startup.}

\item{start}{(integer) start location to browse to on app startup.}

\item{end}{(integer) end location to browse to on app startup.}

\item{debug}{(logical) start epiviz app in debug mode.}

\item{workspace}{(character) a workspace id to load in the epiviz app on startup.}

\item{scripts}{(character) URLs for JavaScript plugin scripts to be imported when epiviz is loaded (see \url{http://epiviz.cbcb.umd.edu/help} for details).}

\item{gists}{(character) Ids for github gists (\url{http://gist.github.com}) containing JavaScript plugin scripts to
be imported when epiviz is loaded (see \url{http://epiviz.cbcb.umd.edu/help} for details).}

\item{use_cookie}{(logical) use cookies within the epiviz app.}

\item{register_function}{(function) function used to register actions and charts on the epiviz app.}

\item{open_browser}{(logical) browse to the epiviz URL before exiting function.}

\item{server}{(EpivizServer) if not \code{NULL} use this object as underlying WebSocket and HTTP server}

\item{browser_fun}{(function) function used to browse to URL (\code{browseURL} by default)}

\item{ws_host}{(character) host address to use for websocket connection ("localhost" by default)}

\item{...}{additional parameters passed to \code{\link[epivizrServer]{createServer}}.}
}
\value{
An object of class \code{\link{EpivizApp}}
}
\description{
Start epiviz app and create \code{\link{EpivizApp}} object to manage connection.
}
\examples{
# see package vignete for example usage
app <- startEpiviz(non_interactive=TRUE, open_browser=TRUE)
app$stop_app()

}
