% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restartEpiviz.R
\name{restartEpiviz}
\alias{restartEpiviz}
\title{Restart epiviz app connection and workspace.}
\usage{
restartEpiviz(file, open_browser = TRUE, host = NULL, envir = parent.frame())
}
\arguments{
\item{file}{(character) The name of the file that holds the EpivizApp object to be restarted, ending in .rda.}

\item{open_browser}{(logical) browse to the epiviz URL before exiting function.}

\item{host}{(character) name of epiviz app host to open at restart}

\item{envir}{(environment) environment in which to evaluate expressions needed to reconstruct data sources}
}
\value{
An object of class \code{\link{EpivizApp}}
}
\description{
Restart epiviz app connection and workspace.
}
\examples{
# see package vignette for example usage
app <- startEpiviz(non_interactive=TRUE, open_browser=TRUE)
file_name <- tempfile(fileext=".rda")
app$save(file=file_name)
app$stop_app()

app <- restartEpiviz(file=file_name, open_browser=FALSE)

}
