% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startStandalone.R
\name{startStandaloneApp}
\alias{startStandaloneApp}
\title{Start a standalone \code{epivizr} session.}
\usage{
startStandaloneApp(
  gene_track = NULL,
  seqinfo = NULL,
  keep_seqlevels = NULL,
  chr = NULL,
  start = NULL,
  end = NULL,
  non_interactive = FALSE,
  register_function = epivizr:::.register_all_the_epiviz_things,
  host = "127.0.0.1",
  ...
)
}
\arguments{
\item{gene_track}{(OrganismDb) an object of type \code{\link[OrganismDbi]{OrganismDb}} or \code{\link[GenomicFeatures]{TxDb}}}

\item{seqinfo}{(Seqinfo) an object of type \code{\link[Seqinfo]{Seqinfo}} from which sequence names and lengths are obtained}

\item{keep_seqlevels}{(character) vector of sequence names to include in the standalone app}

\item{chr}{(character) chromosome to browse to on app startup.}

\item{start}{(integer) start location to browse to on app startup.}

\item{end}{(integer) end location to browse to on app startup.}

\item{non_interactive}{(logical) run server in non-interactive mode. Used for testing and development.}

\item{register_function}{(function) function used to initialize actions in epiviz app. Used for testing and development.}

\item{host}{(character) host address for application (127.0.0.1 by default)}

\item{...}{additional arguments passed to \code{\link[epivizr]{startEpiviz}}.}
}
\value{
An object of class \code{\link[epivizr]{EpivizApp}}
}
\description{
Uses the local installation of the epiviz desktop app to start a standalone epivizr session
through the \code{\link[epivizr]{startEpiviz}} function. The epiviz app requires a list
of sequence names and lengths (e.g., chromsome names and lengths) to setup genome browsing. 
These can be passed in the \code{seqinfo} argument or derived from the \code{gene_track} argument.
The \code{gene_track} argument can be used to pass a genome annotation and add a gene track to the 
epiviz browser. See package vignette for further detail.
}
\examples{
# see package vignete for example usage
seqinfo <- Seqinfo::Seqinfo(c("chr1","chr2"), c(10,20))
app <- startStandalone(seqinfo=seqinfo, non_interactive=TRUE)
app$stop_app()

}
