% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redimMatrix.R
\name{redimMatrix}
\alias{redimMatrix}
\title{redimMatrix()}
\usage{
redimMatrix(
  mat,
  target_height = 100,
  target_width = 100,
  summary_func = function(x) mean(x, na.rm = TRUE),
  output_type = 0,
  n_core = 1
)
}
\arguments{
\item{mat}{the input matrix.}

\item{target_height}{height of the output matrix
(should be smaller than or equal to \code{nrow(mat)}).}

\item{target_width}{width of the output matrix
(should be smaller than or equal to \code{ncol(mat)}).}

\item{summary_func}{how to summerize cells? A function such has
\code{mean}, \code{median}, \code{max}, or \code{meanColors}.}

\item{output_type}{Type of the output, to be passed to \code{vapply}'s
FUN.VALUE.}

\item{n_core}{number of core to use for parallel processing.}
}
\value{
a resized matrix of size \code{target_width} x \code{target_height}
where the \code{summary_fun} was apply
to adjacent cells.
}
\description{
Reduce the input matrix size by applying a summary function on cells to
be fused.
}
\details{
This function is used to reduce matrix right before plotting them
in order to avoid overplotting issues as well as other plotting artefacts.
}
\examples{
data("stackepi")
mat <- SummarizedExperiment::assay(stackepi, "DNAme")
dim(mat)
smallMat <- redimMatrix(mat, target_height = 10, target_width = ncol(mat))
dim(smallMat)

# changing the summary function
mat <- matrix(sample(1:40,100,replace=TRUE),nrow=10,ncol=10)
dim(mat)
smallMat <- redimMatrix(mat, target_height = 5, target_width = ncol(mat),
   summary_func = function(x) max(x, na.rm = TRUE))
dim(smallMat)

# working with colors
colmat <- matrix(
    c("red", "red", "blue", "blue", "red", "blue", "blue", "green"),
    ncol = 2
)
redimMatrix(colmat, target_height = 2, target_width = 2,
            summary_func = meanColor, output_type = "color")

}
\seealso{
\code{\link[epistack]{meanColor}}
}
