% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellAggregation.R
\name{aggregateAcrossCellsFast}
\alias{aggregateAcrossCellsFast}
\title{Aggregate cells in SingleCellExperiment}
\usage{
aggregateAcrossCellsFast(
  sce,
  clusters,
  assay.name = "counts",
  fun_name = c("mean", "sum"),
  num.threads = 1,
  aggregateColData = TRUE
)
}
\arguments{
\item{sce}{A SingleCellExperiment, SummarizedExperiment or RangedSummarizedExperiment object}

\item{clusters}{A vector used as a grouping variable. The length should be equal to
the number of cells.}

\item{assay.name}{A character indicating the name of the assay containing the
values to be aggregated.}

\item{fun_name}{A character indicating the function used to aggregate data. The
selection is restricted to "mean" or "sum".}

\item{num.threads}{Integer specifying the number of threads to be used for aggregation.}

\item{aggregateColData}{A logical specifying if the columns in the \code{colData}
should be included in the output object. Only those columns are selected which
can be decomposed by grouping variable into the vectors whose all elements
are the same.}
}
\value{
A SingleCellExperiment object containing aggregated cells.
}
\description{
Aggregate expression values across cells in SingleCellExperiment based on a
grouping factor. This is primarily used to create pseudo-bulk profiles
for each cluster/sample combination. It is wrapped around \code{scrapper::aggregateAcrossCells},
which relies on the C++ code.
}
\examples{
# create a mock singleCellExperiment object for gene expression matrix
set.seed(1000)
example_sce <- scuttle::mockSCE()
ids <- sample(LETTERS[1:5], ncol(example_sce), replace=TRUE)
out <- aggregateAcrossCellsFast(example_sce, ids)
}
