% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulonPruning.R
\name{addLogFC}
\alias{addLogFC}
\title{Add log fold changes of gene expression to regulons}
\usage{
addLogFC(
  expMatrix,
  clusters,
  regulon,
  pval.type = c("any", "some", "all"),
  sig_type = c("FDR", "p.value"),
  logFC_condition = NULL,
  logFC_ref = NULL,
  ...
)
}
\arguments{
\item{expMatrix}{A SingleCellExperiment object or matrix containing gene expression with
genes in the rows and cells in the columns}

\item{clusters}{A character or integer vector of cluster or group labels for single cells}

\item{regulon}{A dataframe informing the gene regulatory relationship with the \code{tf} column
representing transcription factors, \code{idxATAC} corresponding to the index in the peakMatrix and
\code{target} column representing target genes}

\item{pval.type}{String specifying how p-values are to be combined across pairwise comparisons for a given group/cluster.}

\item{sig_type}{String specifying whether to use "FDR" or "p.value" for sig_cutoff}

\item{logFC_condition}{A scalar or vector of string indicating the sample names to be compared against \code{logFC_ref}}

\item{logFC_ref}{A scalar indicating the reference sample used to compute logFC. Default value is
\code{rest} which is an average of all pairwise comparisons. Users can also specify a reference sample, for example, \code{DMSO}.}

\item{...}{additional parameters for scran::findMarkers}
}
\value{
A DataFrame of regulons with additional columns of logFC and significance
}
\description{
Add log fold changes of gene expression to regulons
}
\examples{
# create a mock singleCellExperiment object for gene expMatrixession matrix
set.seed(1000)
gene_sce <- scuttle::mockSCE()
gene_sce <- scuttle::logNormCounts(gene_sce)
rownames(gene_sce) <- paste0('Gene_',1:2000)

# create a mock regulon
regulon <- data.frame(tf = c(rep('Gene_1',10), rep('Gene_2',10)),
                     idxATAC = sample(1:100, 20),
                     target = c(paste0('Gene_', sample(3:2000,10)),
                                paste0('Gene_',sample(3:2000,10))))

# filter regulon
pruned.regulon <- addLogFC(expMatrix = gene_sce, clusters = gene_sce$Treatment,
                               regulon = regulon,
                               sig_type = "p.value")

}
\author{
Xiaosai Yao
}
