% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{plotGseaNetwork}
\alias{plotGseaNetwork}
\title{Plot networks graph of significant genesets from regulonEnrich results}
\usage{
plotGseaNetwork(
  tf,
  enrichresults,
  ntop_pathways = 10,
  p.adj_cutoff = 0.05,
  layout = "sugiyama",
  tf_label = "tf",
  gset_label = "ID",
  tf_color = "tomato",
  gset_color = "grey"
)
}
\arguments{
\item{tf}{A vector of gene names to be plotted. They should be present in enrichresults}

\item{enrichresults}{Output from regulonEnrich that computes enriched genesets from user-specified regulons
of interest}

\item{ntop_pathways}{An integer indicating the number of top pathways to be included in the graph}

\item{p.adj_cutoff}{A scalar indicating the p.adjusted cutoff for pathways to be included in the graph. Default value is 0.05}

\item{layout}{String indicating layout option from igraph}

\item{tf_label}{String indicating the name of the tf label}

\item{gset_label}{String indicating the name of the geneset label}

\item{tf_color}{String indicating the color of the tf label}

\item{gset_color}{String indicating the color of the geneset label}
}
\value{
an igraph plot of interconnected pathways through TFs
}
\description{
Plot networks graph of significant genesets from regulonEnrich results
}
\examples{
AR <- data.frame(ID = c('ANDROGEN RESPONSE','PROLIFERATION','MAPK'),
p.adjust = c(0.001, 0.01, 0.04))
GATA6 <- data.frame(ID = c('STK33','PROLIFERATION','MAPK'),
p.adjust = c(0.001, 0.01, 0.04))
enrichresults <- list(AR = AR, GATA6 = GATA6)
plotGseaNetwork(tf = names(enrichresults), enrichresults = enrichresults)
}
\author{
Phoebe Guo, Xiaosai Yao
}
