% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{plotEpiregulonNetwork}
\alias{plotEpiregulonNetwork}
\title{Plot a graph build based on \code{getRegulon} output}
\usage{
plotEpiregulonNetwork(
  graph,
  layout = "stress",
  label_size = 3,
  tfs_to_highlight = NULL,
  edge_alpha = 0.02,
  point_size = 1,
  point_border_size = 0.5,
  label_alpha = 0.8,
  label_nudge_x = 0.2,
  label_nudge_y = 0.2,
  ...
)
}
\arguments{
\item{graph}{an igraph object}

\item{layout}{a layout specification. Any values that are valid for
\link[ggraph]{ggraph} or \link[ggraph]{create_layout} will work. Defaults to
'stress'. Consider also trying 'mds', 'nicely', and 'fr' while you experiment.}

\item{label_size}{an integer indicating how large the labels of highlighted
transcription factors should be}

\item{tfs_to_highlight}{a character vector specifying which TFs in the plot
should be highlighted. Defaults to NULL (no labels).}

\item{edge_alpha}{a numeric value between 0 and 1 indicating the level of
transparency to use for the edge links in the force-directed layout. Defaults
to 0.02.}

\item{point_size}{a numeric value indicating the size of nodes in the force-directed layout}

\item{point_border_size}{a numeric value indicating the size of point
borders for nodes in the force-directed layout}

\item{label_alpha}{a numeric value between 0 and 1 indicating the level of
transparency to use for the labels of highlighted nodes}

\item{label_nudge_x}{a numeric value indicating the shift of the labels
along the x axis that should be used in the force-directed layout}

\item{label_nudge_y}{A numeric value indicating the shift of the labels
along the y axis that should be used in the force-directed layout.}

\item{...}{optional additional arguments to pass to \link[ggraph]{create_layout}}
}
\value{
a ggraph object
}
\description{
This function takes an input an igraph object created by any of the following:
\code{buildGraph}, \code{addCentrality}, \code{igraph::strength}, \code{normalizeCentrality}.
It makes a force-directed layout plot to visualize it at a high level.
}
\examples{
# create an artificial getRegulon output
set.seed(1234)
tf_set <- apply(expand.grid(LETTERS[seq_len(5)], LETTERS[seq_len(5)]),1,  paste, collapse = '')
regulon <- data.frame(tf = sample(tf_set, 5e2, replace = TRUE))
gene_set <- expand.grid(LETTERS[seq_len(5)], LETTERS[seq_len(5)], LETTERS[seq_len(5)])
gene_set <- apply(gene_set,1,function(x) paste0(x,collapse=''))
regulon$target <- sample(gene_set, 5e2, replace = TRUE)
regulon$idxATAC <- seq_len(5e2)
regulon$corr <- runif(5e2)*0.5+0.5
regulon$weights <- runif(500)
#create igraph object
graph_tripartite <- buildGraph(regulon, mode = 'tripartite')
plotEpiregulonNetwork(graph_tripartite, tfs_to_highlight = sample(unique(tf_set),3),
edge_alpha = 0.2)
}
\author{
Timothy Keyes, Tomasz Wlodarczyk
}
