% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotBubble}
\alias{plotBubble}
\title{Generate bubble plots of relative activities across cluster/group labels for a list of TFs}
\usage{
plotBubble(
  activity_matrix,
  tf,
  clusters,
  bubblesize = c("log.FDR", "summary.logFC", "summary.diff"),
  color.theme = "viridis",
  legend.label = "relative_activity",
  x.label = "clusters",
  y.label = "transcription factors",
  title = "TF activity",
  ...
)
}
\arguments{
\item{activity_matrix}{A matrix of TF activities inferred from calculateActivity}

\item{tf}{A character vector indicating the names of the transcription factors to be plotted}

\item{clusters}{A character or integer vector of cluster or group labels for single cells}

\item{bubblesize}{String indicating the variable from findDifferentialActivity output to scale size of bubbles
by either \code{log.FDR}, \code{summary.logFC} or \code{summary.diff}. Default is \code{logFDR}.}

\item{color.theme}{String indicating the color theme used for the bubble plot and corresponding to the color options
in \code{scale_color_viridis_c}}

\item{legend.label}{String indicating the name of legend corresponding to the color scale}

\item{x.label}{String indicating the x axis label}

\item{y.label}{String indicating the y axis label}

\item{title}{String indicating the title of the plot}

\item{...}{Additional arguments to pass to \code{findDifferentialActivity}}
}
\value{
A ggplot object
}
\description{
Generate bubble plots of relative activities across cluster/group labels for a list of TFs
}
\examples{
example_sce <- scuttle::mockSCE()
example_sce <- scuttle::logNormCounts(example_sce)
example_sce$cluster <- sample(LETTERS[1:5], ncol(example_sce), replace = TRUE)
plotBubble(activity_matrix = logcounts(example_sce),
tf = c('Gene_0001','Gene_0002'),  clusters = example_sce$cluster)
}
\author{
Shang-yang Chen
}
