% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotActivityViolin}
\alias{plotActivityViolin}
\title{Generate violin plots of inferred activities for a list of TFs grouped by cluster/group labels}
\usage{
plotActivityViolin(
  activity_matrix,
  tf,
  clusters,
  ncol = NULL,
  nrow = NULL,
  combine = TRUE,
  legend.label = "activity",
  colors = NULL,
  title = NULL,
  text_size = 10,
  facet_grid_variable = NULL,
  boxplot = FALSE
)
}
\arguments{
\item{activity_matrix}{A matrix of TF activities inferred from calculateActivity}

\item{tf}{A character vector indicating the names of the transcription factors to be plotted}

\item{clusters}{A vector of cluster or group labels for single cells}

\item{ncol}{A integer to indicate the number of columns in the combined plot, if \code{combine = TRUE}}

\item{nrow}{A integer to indicate the number of rows in the combined plot, if \code{combine = TRUE}}

\item{combine}{logical to indicate whether to combine and visualize the plots in one panel}

\item{legend.label}{String indicating the name of variable to be plotted on the legend}

\item{colors}{A character vector representing the names of colors}

\item{title}{String indicating the title of the plot if \code{combine = TRUE}}

\item{text_size}{Scalar indicating the font size of the title}

\item{facet_grid_variable}{A character vector of a secondary label to split the plots by facet_grid}

\item{boxplot}{logical indicating whether to add boxplot on top of violin plot}
}
\value{
A combined ggplot object or a list of ggplots if \code{combine = FALSE}
}
\description{
Generate violin plots of inferred activities for a list of TFs grouped by cluster/group labels
}
\examples{
# create a mock singleCellExperiment object for gene expression matrix
example_sce <- scuttle::mockSCE()
example_sce <- scuttle::logNormCounts(example_sce)
example_sce$cluster <- sample(LETTERS[1:5], ncol(example_sce), replace = TRUE)
plotActivityViolin(activity_matrix = logcounts(example_sce),
tf = c('Gene_0001','Gene_0002'),  clusters = example_sce$cluster)

}
\author{
Xiaosai Yao, Shang-yang Chen
}
