% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{enrichPlot}
\alias{enrichPlot}
\title{Plot results of regulonEnrich}
\usage{
enrichPlot(results, top = 15, ncol = 3, title = NULL, combine = TRUE)
}
\arguments{
\item{results}{Output from regulonEnrich}

\item{top}{An integer to indicate the number of pathways to plot ranked by significance. Default is 15.}

\item{ncol}{An integer to indicate the number of columns in the combined plot, if combine == TRUE. Default is 3.}

\item{title}{String indicating the title of the combined plot}

\item{combine}{logical to indicate whether to combine and visualize the plots in one panel}
}
\value{
A combined ggplot object or a list of ggplots if combine == FALSE
}
\description{
Plot results of regulonEnrich
}
\examples{
#retrieve genesets
msigdb.hs = msigdb::getMsigdb(org = 'hs', id = 'SYM', version = '7.4')

#convert genesets to be compatible with enricher
msigdb.hs <- msigdb.hs[unlist(lapply(msigdb.hs, function(x) {GSEABase::bcCategory(GSEABase::collectionType(x)) \%in\% c("c6", "h")}))]
gs.list <- do.call(rbind, lapply(names(msigdb.hs), function(x) {
 data.frame(gs = x, genes = GSEABase::geneIds(msigdb.hs[x][[1]]))}))

head(gs.list)

#get regulon
library(dorothea)
data(dorothea_hs, package = 'dorothea')
regulon <- dorothea_hs
enrichment_results <- regulonEnrich(c('ESR1','AR'), regulon = regulon, weight = 'mor',
genesets = gs.list)

# plot graph
enrichPlot(results = enrichment_results )

}
\author{
Xiaosai Yao
}
