% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMotifProf.R
\name{plotMotifProf}
\alias{plotMotifProf}
\title{Plot the profile of motif of specific peak}
\usage{
plotMotifProf(
  df,
  legend_lab = "motif",
  y_lab = "motif score",
  x_lab = NULL,
  interactive = FALSE,
  width_svg = 10,
  height_svg = 6
)
}
\arguments{
\item{df}{motif information data.frame.}

\item{legend_lab}{legend lab.}

\item{y_lab}{y axis label.}

\item{x_lab}{x axis label.}

\item{interactive}{produce interactive fig or not.}

\item{width_svg}{width_svg}

\item{height_svg}{height_svg}
}
\value{
ggplot object
}
\description{
Plot the profile of motif of specific peak
}
\examples{
require(BSgenome.Hsapiens.UCSC.hg38)
data(pwm_obj)
region_oi <- GRanges(seqnames = "chr22", 
                     ranges = IRanges(start = 10525891, end = 10525991))
motifMatrix <- getMotifMatrix(region = region_oi, 
                              pwm = pwm_obj[c(45,120,170)], 
                              ref_obj = BSgenome.Hsapiens.UCSC.hg38)
plotMotifProf(motifMatrix)
}
