% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneTrack.R
\name{plotGeneTrack}
\alias{plotGeneTrack}
\title{Plot gene track}
\usage{
plotGeneTrack(
  txdb,
  chr,
  start_pos,
  end_pos,
  xlab = "",
  ylab = "",
  x_text_size = 10,
  y_text_size = 10,
  select_gene = "all",
  palette = NULL,
  fromType = "ENTREZID",
  highlight = NULL,
  highlight_color = "#c6c3c3",
  highlight_alpha = 0.2,
  OrgDb = NULL,
  show_legend = FALSE,
  auto_x_axis = TRUE
)
}
\arguments{
\item{txdb}{TxDb object, providing gene annotation.}

\item{chr}{chromosome id.}

\item{start_pos}{start coordinate of windows.}

\item{end_pos}{end coordinate of windows.}

\item{xlab}{x lab.}

\item{ylab}{y lab.}

\item{x_text_size}{the size of x text.}

\item{y_text_size}{the size of y text.}

\item{select_gene}{show all gene or specifc gene. (1)"all", show all genes. (2) gene symbol, e.g. c("SKAP1", "EFCAB13"). (3) gene id, e.g. c(4831, 55316)}

\item{palette}{palette, default "Set3".}

\item{fromType}{from which type of gene name to change gene id. Default: ENTREZID. See [clusterProfiler::bitr()]}

\item{highlight}{a region or a list of region to highlight.}

\item{highlight_color}{colors of highlight rect. Default "#c6c3c3"}

\item{highlight_alpha}{alpha of highlight rect.}

\item{OrgDb}{OrgDb for change gene id to gene symbol.}

\item{show_legend}{show legend or not.}

\item{auto_x_axis}{use auto x axis or not.}
}
\value{
ggplot object
}
\description{
Plot gene track
}
\examples{
require(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
plotGeneTrack(txdb = txdb, chr = "chr8", start_pos = 126712193, end_pos = 126712293)
}
