% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBmProf.R
\name{plotBmProf}
\alias{plotBmProf}
\title{plotBmProf}
\usage{
plotBmProf(
  df,
  motif_color = NULL,
  title = NULL,
  xlim = NULL,
  interactive = FALSE,
  width_svg = 10,
  height_svg = 6,
  highlight = NULL,
  highlight_color = "#c6c3c3",
  highlight_alpha = 0.2,
  xlab = "Genomic Region(5'->3')",
  ylab = NULL,
  second_ylab = NULL,
  switch_y_value = TRUE,
  legend_lab_motif = NULL,
  legend_lab_value2 = NULL,
  strip_placement = "outside",
  angle_of_facet_label = 360,
  alpha = 0.6,
  y_ticks_length = 0.25,
  x_ticks_length = 0.25,
  auto_x_axis = TRUE,
  strip_border = FALSE,
  facet_label_text_size = 10,
  axis_title_text_size = 17,
  title_text_size = 20,
  right_y_axis_text_size = 10,
  left_y_axis_text_size = 10,
  x_axis_text_size = 10,
  depth_heatmap = TRUE,
  nrow = NULL,
  ncol = NULL,
  panel_spacing = 1,
  legend_box_spacing = 3,
  legend_position = "right"
)
}
\arguments{
\item{df}{the base modification data.frame}

\item{motif_color}{the color for different motifs(CHH,CHG,CG)}

\item{title}{the title of the plot, can also be a list of title.}

\item{xlim}{the specified interval of region, must be the sub-interval of the dmR. list for list df}

\item{interactive}{produce interactive fig or not.}

\item{width_svg}{width_svg.}

\item{height_svg}{height_svg.}

\item{highlight}{a region or a list of region to highlight.}

\item{highlight_color}{colors of highlight rect. Default "#c6c3c3"}

\item{highlight_alpha}{alpha of highlight rect.}

\item{xlab}{the x label, can also be a list of x label}

\item{ylab}{the y label, can also be a list of y label}

\item{second_ylab}{the ylab for second y-axis}

\item{switch_y_value}{switch the value from left y-axis to right y-axis}

\item{legend_lab_motif}{the label of legend for motif}

\item{legend_lab_value2}{the label of legend for the second value(ylab is the label for the first value)}

\item{strip_placement}{strip.placement}

\item{angle_of_facet_label}{the angle of facet label, e.g. 0 is horizontal}

\item{alpha}{transparency for the depth information line}

\item{y_ticks_length}{the length of y-axis ticks}

\item{x_ticks_length}{the length of x-axis ticks}

\item{auto_x_axis}{use auto x axis or not.}

\item{strip_border}{add border to the facet label or not}

\item{facet_label_text_size}{the size of facet label text}

\item{axis_title_text_size}{the size of axis title text}

\item{title_text_size}{the size of the title text}

\item{right_y_axis_text_size}{the size of the left y axis text,this work when depth information is taken into account}

\item{left_y_axis_text_size}{the size of the left y axis text}

\item{x_axis_text_size}{the size of x axis text}

\item{depth_heatmap}{draw the heatmap of depth information or not}

\item{nrow}{the nrow of plotting a list of dmR}

\item{ncol}{the ncol of plotting a list of dmR}

\item{panel_spacing}{the distance between panels}

\item{legend_box_spacing}{the distance between legend and plotting area,"cm"}

\item{legend_position}{the position of legend}
}
\value{
ggplot object
}
\description{
Plot base modification profile
}
\examples{
require(BSgenome.Hsapiens.UCSC.hg38)
data(demo_bmdata)
bmMatrix <- getBmMatrix(region = data.frame(chr = "chr22", start = 10525991, end = 10526342),
                        BSgenome = BSgenome.Hsapiens.UCSC.hg38,
                        input = demo_bmdata,
#                          base = "C",
                        motif = c("CG"))
plotBmProf(bmMatrix)
}
