% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMotifMatrix.R
\name{getMotifMatrix}
\alias{getMotifMatrix}
\title{Get the information of motif in a range}
\usage{
getMotifMatrix(region, pwm, ref_obj, by = "name")
}
\arguments{
\item{region}{region object in granges.}

\item{pwm}{PFMatrixList.}

\item{ref_obj}{seq reference object. e.g. BSgenome object.}

\item{by}{show the motif by name or ID.}
}
\value{
score matrix
}
\description{
Get the information of motif in a range
}
\examples{
require(BSgenome.Hsapiens.UCSC.hg38)
data(pwm_obj)
  
region_oi <- GRanges(seqnames = "chr22", 
                     ranges = IRanges(start = 10525891, end = 10525991))
motifMatrix <- getMotifMatrix(region = region_oi, 
                              pwm = pwm_obj[c(45,120,170)], 
                              ref_obj = BSgenome.Hsapiens.UCSC.hg38)

}
