% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBmMatrix.R
\name{getBmMatrix.BSseq}
\alias{getBmMatrix.BSseq}
\title{Get the information of base modification}
\usage{
getBmMatrix.BSseq(
  region,
  input,
  BSgenome,
  cover_depth = TRUE,
  base = NULL,
  motif = NULL,
  position_bias = NULL
)
}
\arguments{
\item{region}{base modification region in the form of data.frame, having columns of "chr","start" and "end"}

\item{input}{the input data stored in [bsseq::BSseq] objects}

\item{BSgenome}{genome reference}

\item{cover_depth}{take the depth of cover into account or not}

\item{base}{one of A/T/G/C/U}

\item{motif}{the motif(e.g C:CG/CH, A:GAGG/AGG) of the base modification}

\item{position_bias}{1-base bias. e.g position_bias = 1("C" in "CHH"), position_bias = 2("A" in "GAGG")}
}
\value{
data.frame
}
\description{
Get the information of base modification
}
\details{
This function retrieve the information of each base, requiring [bsseq::BSseq] object as input.
   Then organized it to data.frame.
}
