% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BSseq-class.R,
%   R/bmData-class.R
\docType{methods}
\name{getBmMatrix}
\alias{getBmMatrix}
\alias{getBmMatrix,ANY,BSseq-method}
\alias{getBmMatrix,}
\alias{BSseq-methods}
\alias{getBmMatrix,ANY,bmData-method}
\alias{bmData-methods}
\title{getBmMatrix methods generics}
\usage{
getBmMatrix(
  region,
  input,
  BSgenome,
  base = NULL,
  motif = NULL,
  position_bias = NULL,
  ...
)

\S4method{getBmMatrix}{ANY,BSseq}(
  region,
  input,
  BSgenome,
  base = NULL,
  motif = NULL,
  position_bias = NULL,
  cover_depth = TRUE,
  ...
)

\S4method{getBmMatrix}{ANY,bmData}(
  region,
  input,
  BSgenome,
  base = NULL,
  motif = NULL,
  position_bias = NULL,
  ...
)
}
\arguments{
\item{region}{base modification region in the form of dataframe, having columns of "chr","start" and "end"}

\item{input}{the input data stored in BSseq objects or BSseqExtra objects}

\item{BSgenome}{genome reference}

\item{base}{one of A/T/G/C/U}

\item{motif}{the motif(e.g C:CG/CH, A:GAGG/AGG) of the base modification}

\item{position_bias}{1-base bias. e.g position_bias = 1("C" in "CHH"), position_bias = 2("A" in "GAGG")}

\item{...}{other parameters}

\item{cover_depth}{take the depth of cover into account or not}
}
\value{
data.frame

dataframe
}
\description{
getBmMatrix method for [bsseq::BSseq]

getBmMatrix method for \linkS4class{bmData}
}
\examples{
require(BSgenome.Hsapiens.UCSC.hg38)
data(demo_bmdata)
bmMatrix <- getBmMatrix(region = data.frame(chr = "chr22", start = 10525991, end = 10526342),
                        BSgenome = BSgenome.Hsapiens.UCSC.hg38,
                        input = demo_bmdata,
                        base = "C",
                        motif = c("CG"))
}
