% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{barplot.enrichResult}
\alias{barplot.enrichResult}
\title{barplot}
\usage{
\method{barplot}{enrichResult}(
  height,
  x = "Count",
  color = "p.adjust",
  showCategory = 8,
  font.size = 12,
  title = "",
  label_format = 30,
  ...
)
}
\arguments{
\item{height}{enrichResult object}

\item{x}{one of 'Count' and 'GeneRatio'}

\item{color}{one of 'pvalue', 'p.adjust' and 'qvalue'}

\item{showCategory}{number of categories to display or a vector of terms.}

\item{font.size}{font size}

\item{title}{plot title}

\item{label_format}{a numeric value sets wrap length, alternatively a
custom function to format axis labels.
by default wraps names longer than 30 characters}

\item{...}{additional parameters}
}
\value{
ggplot object
}
\description{
Barplot of enrichResult
}
\details{
Barplot of enrichResult
}
\examples{
library(DOSE)
data(geneList)
de <- names(geneList)[1:100]
x <- enrichDO(de)
barplot(x)
# use `showCategory` to select the displayed terms. It can be a number of a vector of terms.
barplot(x, showCategory = 10)
categories <- c("urinary bladder cancer", "bronchiolitis obliterans",
               "aortic aneurysm", "esophageal cancer")
barplot(x, showCategory = categories)
}
