% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ridgeplot.R
\name{ridgeplot}
\alias{ridgeplot}
\alias{ridgeplot,gseaResult-method}
\alias{ridgeplot.gseaResult}
\title{ridgeplot}
\usage{
ridgeplot(
  x,
  showCategory = 30,
  fill = "p.adjust",
  core_enrichment = TRUE,
  label_format = 30,
  ...
)

\S4method{ridgeplot}{gseaResult}(
  x,
  showCategory = 30,
  fill = "p.adjust",
  core_enrichment = TRUE,
  label_format = 30,
  ...
)

ridgeplot.gseaResult(
  x,
  showCategory = 30,
  fill = "p.adjust",
  core_enrichment = TRUE,
  label_format = 30,
  orderBy = "NES",
  decreasing = FALSE
)
}
\arguments{
\item{x}{gseaResult object}

\item{showCategory}{A number or a vector of terms. If it is a number,
the first n terms will be displayed. If it is a vector of terms,
the selected terms will be displayed.}

\item{fill}{one of "pvalue", "p.adjust", "qvalue"}

\item{core_enrichment}{whether only using core_enriched genes}

\item{label_format}{a numeric value sets wrap length, alternatively a
custom function to format axis labels.}

\item{...}{additional parameters
by default wraps names longer that 30 characters}

\item{orderBy}{The order of the Y-axis}

\item{decreasing}{logical. Should the orderBy order be increasing or decreasing?}
}
\value{
ggplot object
}
\description{
ridgeline plot for GSEA result
}
\examples{
\donttest{
library(DOSE)
data(geneList)
x <- gseDO(geneList)
ridgeplot(x)
}
}
\author{
Guangchuang Yu
}
