% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRegionsFromTxDb.R
\name{getRegionsFromTxDb}
\alias{getRegionsFromTxDb}
\title{Get exonic/gene body regions from a transcript database.}
\usage{
getRegionsFromTxDb(txdb, exonExt = 10L, strandedData = TRUE)
}
\arguments{
\item{txdb}{a \code{TxDb} or an \code{EnsDb} object with the transcript annotations.}

\item{exonExt}{\code{numeric} (default = 10L). Exonic ranges will be extended
on either side by this many nucleotides, in order to avoid "bleed-over" of
exonic alignments into adjacent intronic regions.}

\item{strandedData}{\code{logical(1)}. If \code{TRUE}, the RNA-seq data is
assumed to be strand-specific, and therefore only overlapping genes that
are on the same strand will be filtered out. If \code{FALSE}, also genes
overlapping on opposite strands will be filtered out.}
}
\value{
a \code{list} with elements "exons" and "genebodies", containing
named \code{GenomicRanges} objects with ranges for exons and gene bodies,
respectively.
}
\description{
From a transcript database package (\code{\link[GenomicFeatures:TxDb-class]{TxDb}}),
extract exonic and gene body ranges for use with EISA. These regions can
be used to quantify RNA-seq alignments in exons and gene bodies, respectively.
Intronic counts can then be obtained from the difference between gene bodies
and exonic region counts.
}
\details{
The exonic regions are generated as follows:
\enumerate{
\item extract exons by gene from the \code{txdb}
\item extend each exon by \code{exonExt}
\item combine overlapping exons within each gene
\item create gene body ranges from the most extreme exonic coordinates
\item filter out genes that have only a single exon (no intron), have exons
on more than a single chromosome or on both strands, or that
overlap other genes
}
}
\examples{
if (requireNamespace("AnnotationDbi", quietly = TRUE)) {
    txdb <- AnnotationDbi::loadDb(system.file("extdata", "hg19sub.sqlite", package = "eisaR"))
    regL <- getRegionsFromTxDb(txdb)
    lengths(regL)
}

}
\seealso{
\code{\link[GenomicFeatures:TxDb-class]{TxDb}} for details on
\code{TxDb} objects and the \code{txdbmaker} package for how to create them,
e.g. from \code{.gtf} files.
}
\author{
Michael Stadler
}
