% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R, R/setMethods.R
\docType{methods}
\name{individual}
\alias{individual}
\alias{individual,deSet-method}
\alias{individual<-}
\alias{individual<-,deSet-method}
\title{Individuals sampled in experiment}
\usage{
individual(object)

individual(object) <- value

\S4method{individual}{deSet}(object)

\S4method{individual}{deSet}(object) <- value
}
\arguments{
\item{object}{\code{\linkS4class{deSet}}}

\item{value}{\code{factor}: Identifies which samples correspond to which
individuals. Important if the same individuals are sampled multiple times
in a longitudinal fashion.}
}
\value{
\code{individual} returns information regarding dinstinct individuals
  sampled in the experiment.
}
\description{
These generic functions access and set the individual slot in
\code{\linkS4class{deSet}}.
}
\examples{
library(splines)
# import data
data(endotoxin)
ind <- endotoxin$ind
time <- endotoxin$time
class <- endotoxin$class
endoexpr <- endotoxin$endoexpr
cov <- data.frame(individual = ind, time = time, class = class)

# create ExpressionSet object
pDat <- as(cov, "AnnotatedDataFrame")
exp_set <- ExpressionSet(assayData = endoexpr, phenoData = pDat)

# formulate null and full models in experiement
# note: interaction term is a way of taking into account group effects
mNull <- ~ns(time, df=4, intercept = FALSE)
mFull <- ~ns(time, df=4, intercept = FALSE) +
ns(time, df=4, intercept = FALSE):class + class

# create deSet object
de_obj <- deSet(exp_set, full.model = mFull, null.model = mNull,
individual = ind)

# extract out the individuals factor
ind_exp <- individual(de_obj)

}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\linkS4class{deSet}}
}

