% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-BamFileList.R
\name{getBamFileList}
\alias{getBamFileList}
\alias{getBamFileList,character,character-method}
\alias{getBamFileList,character,missing-method}
\title{Get a BamFileList from a list of filenames}
\usage{
\S4method{getBamFileList}{character,character}(filenames = character(0), indexnames = character(0))
}
\arguments{
\item{filenames}{a character vector containing fully defined BAM file filenames}

\item{indexnames}{a character vector containing fully defined BAM index file filenames}
}
\value{
a \code{\link[Rsamtools:BamFile-class]{BamFileList-class}}
}
\description{
A utility function to create a \code{\link[Rsamtools:BamFile-class]{BamFileList-class}}
object from a set of filenames. The filenames need to contain the file path if they
are not in the working directory.
}
\examples{
# tutorial data - store the data in the BiocCache
tdir <- tutorialData()

  # creating a BamFileList using a directory and pattern
  # using filenames (from the Bioc cache)
  filenames <- dir(tdir,pattern="[A,C,T,G]{6}\\\\.bam$",full.names=TRUE)
  indexnames <- sapply(paste0(sub(".*_","",basename(filenames)),".bai"),fetchData)
  bfl <- getBamFileList(filenames,indexnames)

  # get them recursively
  filenames <- dir(path=tdir,pattern="[A,C,T,G]{6}\\\\.bam$",
                   full.names=TRUE,recursive=TRUE)
  indexnames <- sapply(paste0(sub(".*_","",basename(filenames)),".bai"),fetchData)
  bfl <- getBamFileList(filenames,indexnames)

}
\seealso{
\code{\link[Rsamtools:BamFile-class]{BamFileList-class}}
\code{\link[base:list.files]{dir}}
}
