% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocFileCache.R
\docType{methods}
\name{BiocFileCache methods}
\alias{BiocFileCache methods}
\alias{.get_cache}
\alias{.get_cache,ANY-method}
\alias{fetchData}
\alias{fetchData,character-method}
\alias{tutorialData}
\alias{tutorialData,ANY-method}
\alias{vignetteData}
\alias{vignetteData,ANY-method}
\title{Manages the data necessary for the examples using BiocFileCache}
\usage{
fetchData(fileURL)
tutorialData(\dots)
}
\arguments{
\item{\dots}{unused for the time being}

\item{fileURL}{The URL of the file to retrieve. Alternatively, the ID of the
file in the BiocFileCache (i.e. the file basename), can be used.}
}
\description{
Manages the tutorial, example and vignette data using the
\code{\linkS4class{BiocFileCache}} package
}
\section{Methods}{
 \describe{
\item{.get_cache}{internal function to set up the cache}
\item{fetchData}{A function to fetch tutorial data, a file at a time}
\item{tutorialData}{the function to retrieve all the tutorial data and
cache it, if it is not already available}
\item{vignetteData}{the function to retrieve all the tutorial data and
cache it, if it is not already available}}
}

\examples{
tdir <- tutorialData()
gAnnot.path <- fetchData("gAnnot.rda")
vdir <- vignetteData()
md5.txt <- fetchData("md5.txt")
}
\seealso{
\code{\linkS4class{BiocFileCache}}
}
\keyword{methods}
