% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_z_score.R
\name{calc_z_score}
\alias{calc_z_score}
\title{Perform matrix Z-score normalization}
\usage{
calc_z_score(X, mean, sd)
}
\arguments{
\item{X}{numeric matrix.}

\item{mean}{numeric vector with mean values.}

\item{sd}{numeric vector with standard deviation values.}
}
\value{
A numeric matrix with values as z-scores.
}
\description{
Applies z-score normalization on a numeric matrix per column.
Z-score values are calculated based on the input matrix. If
mean and standard deviation values are provided, these are used
instead.
}
\examples{
\donttest{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# apply z-score normalization
tpm_zscore <- calc_z_score(t(RNA_tpm))
}
}
