% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{stopIfInvalidSignature}
\alias{stopIfInvalidSignature}
\title{Validate signature data structure and content}
\usage{
stopIfInvalidSignature(signature)
}
\arguments{
\item{signature}{A data.frame-like object containing signature data that
should be validated for iLINCS compatibility.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This function performs comprehensive validation of signature data to ensure
it meets the requirements for iLINCS analysis.
}
\details{
This function performs two main validation checks:
\enumerate{
\item Column structure validation via \code{\link[=.stopIfInvalidColNames]{.stopIfInvalidColNames()}}
\item Missing value validation via \verb{[.stopIfContainsMissingValues()]}
}

The signature must have exactly the required columns in the correct order
and cannot contain any missing (NA) values.
}
\examples{
NULL
}
\seealso{
\verb{[ prepareSignature() ]} for preparing signatures that meet these requirements,
\verb{[ .stopIfInvalidColNames() ]} for column validation details,
\verb{[ .stopIfContainsMissingValues() ]} for missing value validation details
}
\keyword{internal}
