% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{stopIfInvalidLibraries}
\alias{stopIfInvalidLibraries}
\title{Stop if the libraries are invalid}
\usage{
stopIfInvalidLibraries(libs)
}
\arguments{
\item{libs}{A character vector of library names to validate.
Each library must be one of "OE", "KD", or "CP".}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function validates library specifications and stops execution
with an informative error message if any invalid libraries are found.
}
\details{
This function validates that all provided library names are supported:
\itemize{
\item \code{"OE"}: Overexpression library (LIB_11)
\item \code{"KD"}: Knockdown library (LIB_6)
\item \code{"CP"}: Chemical Perturbagen library (LIB_5)
}

If any invalid libraries are found, the function provides a detailed error
message listing the invalid libraries and the expected options.
}
\examples{
NULL
}
\seealso{
\verb{[ validateLibraries() ]} for the underlying validation logic,
\verb{[ .validateLibrary() ]} for single library validation
}
\keyword{internal}
