% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{.stopIfContainsMissingValues}
\alias{.stopIfContainsMissingValues}
\title{Validate signature for missing values}
\usage{
.stopIfContainsMissingValues(signature)
}
\arguments{
\item{signature}{A data.frame-like object containing signature data.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function checks if the signature data frame contains any
missing (NA) values, which are not allowed in iLINCS signature data.
}
\details{
The function scans the entire signature data frame for missing values.
iLINCS requires complete data for all signature analysis, so any NA values
will cause the function to stop with an informative error message indicating
which columns contain missing values.
}
\examples{
NULL
}
\keyword{internal}
