% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.returnResults}
\alias{.returnResults}
\title{Return results in appropriate format based on input type}
\usage{
.returnResults(result, inputClass)
}
\arguments{
\item{result}{A tibble containing the processed results from iLINCS API.}

\item{inputClass}{A character vector containing the class of the original
input signature (from \code{.validateGetConcordantsInput}).}
}
\value{
The results in the appropriate format:
* S4Vectors::DataFrame if input was a DataFrame
* tibble otherwise (for data.frame, tibble inputs)
}
\description{
This internal function formats the output results to match the input
signature type, ensuring consistent data type handling.
}
\details{
This function ensures that the output format matches the input format
for consistency. If the original signature was provided as an
S4Vectors::DataFrame, the results are converted back to DataFrame.
Otherwise, results are returned as a tibble.
}
\examples{
NULL
}
\keyword{internal}
