% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSignature.R
\name{.processToL1000Signature}
\alias{.processToL1000Signature}
\title{Process differential expression data into L1000 signature format}
\usage{
.processToL1000Signature(
  filteredData,
  geneColumn,
  logfcColumn,
  pvalColumn = NA
)
}
\arguments{
\item{filteredData}{A dataframe containing filtered differential expression data.}

\item{geneColumn}{Character string specifying the column name containing gene symbols.}

\item{logfcColumn}{Character string specifying the column name containing log fold-change values.}

\item{pvalColumn}{Character string specifying the column name containing p-values, or NA.}
}
\value{
A tibble with the standardized L1000 signature format.
}
\description{
This internal function orchestrates the conversion of filtered differential
expression data into the standardized L1000 signature format.
}
\details{
This function dispatches to appropriate mapping functions based on whether
p-value information is available:
\enumerate{
\item \code{.mapToL1000WithPvalues} when p-value column is specified
\item \code{.mapToL1000WithoutPvalues} when p-value column is NA
}
}
\keyword{internal}
