% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignature.R
\name{.processSignatureResponse}
\alias{.processSignatureResponse}
\title{Process iLINCS API response for signature retrieval}
\usage{
.processSignatureResponse(response)
}
\arguments{
\item{response}{An httr2 response object from the iLINCS API.}
}
\value{
A tibble containing signature data with standardized columns.
}
\description{
This internal function dispatches to appropriate handlers based on the
response status from the iLINCS API.
}
\details{
The function dispatches to specialized handlers:
\enumerate{
\item \code{.processSignatureResponseError()} for HTTP error responses
\item \code{.processSuccessfulResponse()} for successful responses with data
}

The resulting tibble contains these columns:
\itemize{
\item \code{signatureID}: The signature identifier
\item \code{ID_geneid}: Character gene identifiers
\item \code{Name_GeneSymbol}: Gene symbols
\item \code{Value_LogDiffExp}: Log fold-change values (rounded to 12 decimal places)
\item \code{Significance_pvalue}: P-values (rounded to 12 decimal places)
}
}
\keyword{internal}
