% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.processIlincsResponse}
\alias{.processIlincsResponse}
\title{Process iLINCS API response into concordant signatures}
\usage{
.processIlincsResponse(response, sigDirection, ilincsLibrary)
}
\arguments{
\item{response}{An httr2 response object from the iLINCS API.}

\item{sigDirection}{Character string indicating the signature direction
("Up", "Down", or "Any").}

\item{ilincsLibrary}{Character string specifying the iLINCS library used
("CP", "KD", or "OE").}
}
\value{
A tibble containing concordant signature data with standardized
column names and rounded numerical values.
}
\description{
This internal function dispatches to appropriate handlers based on the
response status and content from the iLINCS API.
}
\details{
The function dispatches to specialized handlers:
\enumerate{
\item \code{.processIlincsResponseError} for HTTP error responses
\item \code{.processIlincsResponseEmpty} for empty concordance tables
\item \code{.processIlincsResponseSuccess} for successful responses with data
}

The resulting tibble always contains these columns in order:
\itemize{
\item \code{signatureid}: Unique signature identifier
\item \code{treatment}: Drug/treatment name (compound renamed for CP library)
\item \code{concentration}: Drug concentration (NA for KD/OE libraries)
\item \code{time}: Treatment duration
\item \code{cellline}: Cell line used
\item \code{similarity}: Similarity score (rounded to 8 decimal places)
\item \code{pValue}: Statistical significance (rounded to 20 decimal places)
\item \code{sig_direction}: Signature direction ("Up", "Down", or "Any")
\item \code{sig_type}: Library type description
}
}
\keyword{internal}
