% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.generateIlincsRequest}
\alias{.generateIlincsRequest}
\title{Create iLINCS API request}
\usage{
.generateIlincsRequest(signatureFile, ilincsLibrary)
}
\arguments{
\item{signatureFile}{Character string path to the signature file to upload.}

\item{ilincsLibrary}{Character string specifying the iLINCS library to search.
Must be one of "OE", "KD", or "CP".}
}
\value{
An httr2 response object from the iLINCS API.
}
\description{
This internal function constructs and executes the HTTP request to the
iLINCS API for concordant signature analysis.
}
\details{
The function:
\enumerate{
\item Maps the library name to the internal iLINCS library ID
\item Constructs a multipart POST request with the signature file
\item Includes appropriate user agent and API endpoint
\item Executes the request and returns the response
}

The library mapping is:
\itemize{
\item CP (Chemical Perturbagen): LIB_5
\item KD (Knockdown): LIB_6
\item OE (Overexpression): LIB_11
}
}
\examples{
NULL
}
\keyword{internal}
