% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.combineConcordantsData}
\alias{.combineConcordantsData}
\title{Combine concordants dataframes for consensus analysis}
\usage{
.combineConcordantsData(dots)
}
\arguments{
\item{dots}{A list of dataframes to combine.}
}
\value{
A combined dataframe with all input data.
}
\description{
This internal function combines one or more concordants dataframes into a
single dataframe for further processing.
}
\details{
This function:
\enumerate{
\item Combines multiple dataframes using row binding
\item Preserves all columns from input dataframes
\item Handles cases where dataframes have different column sets
}
}
\examples{
\dontrun{
df1 <- data.frame(similarity = 0.5, compound = "A")
df2 <- data.frame(similarity = -0.3, compound = "B")
combined <- .combineConcordantsData(list(df1, df2))
}
}
\keyword{internal}
