% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.applySimilarityCutoff}
\alias{.applySimilarityCutoff}
\title{Apply similarity cutoff filter to concordants data}
\usage{
.applySimilarityCutoff(concordants, cutoff)
}
\arguments{
\item{concordants}{A dataframe containing concordants data.}

\item{cutoff}{Numeric similarity cutoff value.}
}
\value{
A filtered dataframe containing only entries meeting the similarity cutoff.
}
\description{
This internal function filters concordants data based on absolute similarity values
meeting or exceeding the specified cutoff threshold.
}
\details{
This function:
\enumerate{
\item Filters based on absolute similarity values
\item Retains both positive and negative similarities above threshold
\item Removes entries below the cutoff threshold
}
}
\examples{
\dontrun{
testData <- data.frame(similarity = c(0.5, -0.8, 0.2, -0.1))
filtered <- .applySimilarityCutoff(testData, 0.3)
# Returns entries with |similarity| >= 0.3
}
}
\keyword{internal}
