#' drugfindR-package
#' @name drugfindR-package
#' @title drugfindR: Drug Repurposing using Gene Expression Signatures
#' @description drugfindR is a package that allows users to perform drug
#' repurposing using gene expression signatures. It uses the LINCS L1000
#' signatures available from iLINCS  to find the most similar gene expression signatures to the user's
#' input signature. It then uses the connectivity analysis to find the most
#' similar
#' drugs to the user's input signature.
#' @details
#' The drugfindR package allows users to perform drug repurposing using gene
#' expression signatures. It uses the LINCS L1000 database to find the most
#' similar gene expression signatures to the user's input signature. It then
#' uses the connectivity analysis to find the most similar drugs to the user's
#' input signature.
#' @section References:
#' 1. Imami, Ali S., Sinead M. O'donovan, Justin F. Creeden,
#' Xiaojun Wu, Hunter Eby, Cheryl B. McCullumsmith, Kerstin Uvnas-Moberg,
#' Robert E. McCullumsmith, and Elissar Andari.
#' "Oxytocin's Anti-Inflammatory and Proimmune Functions in Covid-19:
#' A Transcriptomic Signature-Based Approach."
#' Physiological Genomics, 2020.
#' https://doi.org/10.1152/physiolgenomics.00095.2020.
#' 2. O'Donovan, Sinead M., Ali Imami, Hunter Eby,
#' Nicholas D. Henkel, Justin Fortune Creeden, Sophie Asah, Xiaolu Zhang, et al.
#' "Identification of Candidate Repurposable Drugs to Combat COVID-19
#' Using a Signature-Based Approach."
#' Scientific Reports 11, no. 1 (December 24, 2021): 4495.
#' https://doi.org/10.1038/s41598-021-84044-9.
#' 3. Creeden, Justin Fortune, Ali Sajid Imami, Hunter M. Eby, Cassidy Gillman,
#' Kathryn N. Becker, Jim Reigle, Elissar Andari, et al.
#' "Fluoxetine as an Anti-Inflammatory Therapy in SARS-CoV-2 Infection."
#' Biomedicine & Pharmacotherapy 138 (June 1, 2021): 111437.
#' https://doi.org/10.1016/j.biopha.2021.111437.
#' @section Author:
#' Ali Sajid Imami
#' @section Maintainer:
#' Ali Sajid Imami
#' @section Contributors:
#' Smita Sahay
#' Justin Fortune Creeden
#' Sinead M. O'Donovan
#' Hunter Eby
#' @section License:
#' GNU Public License 3.0
#' @section Acknowledgements:
#' * This work was supported by the National Institutes
#' of Mental Health of the USA.
#' * This work was heavily supported by the members of
#' the [Cognitive Disorders Research Lab](https://cdrl-ut.org).
#' * This work was made possible by the Fulbright Scholar
#' Program with the Fulbright Masters Grant
#' awarded to Ali Sajid Imami.
#' @keywords internal
#'
"_PACKAGE"

# The following block is used by usethis to automatically manage
# roxygen namespace tags. Modify with care!
## usethis namespace: start
#' @import lifecycle
#' @importFrom lifecycle deprecated
## usethis namespace: end
NULL

# Declare global variables to avoid R CMD check NOTEs
utils::globalVariables(c(
    ".data", # rlang/dplyr pronoun for tidy evaluation
    "cpMetadata", # Package data: L1000 Chemical Perturbagen metadata
    "kdMetadata", # Package data: L1000 Gene Knockdown metadata
    "oeMetadata", # Package data: L1000 Gene Overexpression metadata
    "l1000", # Package data: L1000 gene mapping data
    "stopIfInvalidSignature", # Exported function called internally
    "stopIfInvalidLibraries", # Exported function called internally
    "filterSignature", # Exported function called internally
    "getConcordants", # Exported function called internally
    "consensusConcordants", # Exported function called internally
    "prepareSignature", # Exported function called internally
    "getSignature", # Exported function called internally
    "DataFrame", # S4Vectors::DataFrame imported and used
    "targetRename" # Internal function used in rename_with()
))
