% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVarPart.R
\name{plotVarPart,DataFrame-method}
\alias{plotVarPart,DataFrame-method}
\alias{plotVarPart,DataFrame,DataFrame-method}
\title{Violin plot of variance fractions}
\usage{
\S4method{plotVarPart}{DataFrame}(
  obj,
  col = c(ggColorHue(base::ncol(obj) - 3), "grey85"),
  label.angle = 20,
  main = "",
  ylab = "",
  convertToPercent = TRUE,
  ncol = 3,
  ...
)
}
\arguments{
\item{obj}{\code{varParFrac} object returned by \code{fitExtractVarPart} or \code{extractVarPart}}

\item{col}{vector of colors}

\item{label.angle}{angle of labels on x-axis}

\item{main}{title of plot}

\item{ylab}{text on y-axis}

\item{convertToPercent}{multiply fractions by 100 to convert to percent values}

\item{ncol}{number of columns in the plot}

\item{...}{additional arguments}
}
\value{
Violin plot showing variance fractions
}
\description{
Violin plot of variance fraction for each gene and each variable
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# variance partitioning analysis
vp <- fitVarPart(res.proc, ~group_id)

# Summarize variance fractions genome-wide for each cell type
plotVarPart(vp)

}
