% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_intron_counts}
\alias{get_intron_counts}
\title{Get a data frame of intron counts per gene}
\usage{
get_intron_counts(txdb)
}
\arguments{
\item{txdb}{A \code{TxDb} object with transcript annotations. See details below
for examples on how to create \code{TxDb} objects from different kinds of input.}
}
\value{
A data frame with intron counts per gene, with variables:
\describe{
\item{gene}{Character with gene IDs.}
\item{introns}{Numeric with number of introns per gene.}
}
}
\description{
Get a data frame of intron counts per gene
}
\details{
The family of functions \code{makeTxDbFrom*} from
the \strong{txdbmaker} package can be used to create \code{TxDb} objects
from a variety of input data types. You can create \code{TxDb} objects
from e.g., \code{GRanges} objects (\code{makeTxDbFromGRanges()}),
GFF files (\code{makeTxDbFromGFF()}),
an Ensembl database (\code{makeTxDbFromEnsembl}), and
a Biomart database (\code{makeTxDbFromBiomart}).
}
\examples{
data(yeast_annot)

# Create TxDb object from GRanges
library(txdbmaker)
txdb <- txdbmaker::makeTxDbFromGRanges(yeast_annot[[1]])

# Get intron counts
intron_counts <- get_intron_counts(txdb)
}
